<?php
// database.php
require_once 'config.php';

class Database {
    public $pdo;

    public function __construct() {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        try {
            $this->pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
               
    $this->pdo->exec("set names utf8mb4");

        } catch (PDOException $e) {
            die("Connection failed: " . $e->getMessage());
        }
    }

    public function install() {
        $queries = [
            "CREATE TABLE IF NOT EXISTS users (
                id BIGINT PRIMARY KEY,
                name VARCHAR(255),
                phone VARCHAR(50),
                step VARCHAR(50) DEFAULT 'none',
                 temp_data LONGTEXT,
                joined_at DATETIME DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;",

            "CREATE TABLE IF NOT EXISTS categories (
                id INT AUTO_INCREMENT PRIMARY KEY,
                name VARCHAR(255) NOT NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;",

            "CREATE TABLE IF NOT EXISTS products (
                id INT AUTO_INCREMENT PRIMARY KEY,
                category_id INT,
                title VARCHAR(255),
                description TEXT,
                more_description LONGTEXT DEFAULT NULL,
                thumbnail VARCHAR(255),
                price DECIMAL(15,0),
                discount_price DECIMAL(15,0) DEFAULT 0,
                discount_expiry DATE DEFAULT NULL,
                preview_link VARCHAR(255),
                support_days INT DEFAULT 0,
                views INT DEFAULT 0,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;",

            "CREATE TABLE IF NOT EXISTS product_gallery (
                id INT AUTO_INCREMENT PRIMARY KEY,
                product_id INT,
                file_path VARCHAR(255),
                file_type VARCHAR(50)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;",

            "CREATE TABLE IF NOT EXISTS product_files (
                id INT AUTO_INCREMENT PRIMARY KEY,
                product_id INT,
                file_path VARCHAR(255),
                file_name VARCHAR(255),
                caption TEXT DEFAULT NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;",

            "CREATE TABLE IF NOT EXISTS coupons (
                id INT AUTO_INCREMENT PRIMARY KEY,
                code VARCHAR(100) UNIQUE NOT NULL,
                target_currency ENUM('toman', 'stars') NOT NULL,
                type ENUM('percent', 'fixed') NOT NULL,
                amount BIGINT NOT NULL,
                expiry_date DATE NOT NULL,
                usage_limit INT DEFAULT -1,
                used_count INT DEFAULT 0,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;",


            "CREATE TABLE IF NOT EXISTS orders (
                id INT AUTO_INCREMENT PRIMARY KEY,
                user_id BIGINT,
                product_id INT,
                amount DECIMAL(15,0),
                authority VARCHAR(255),
                status VARCHAR(50) DEFAULT 'pending',
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;"
            
                        ,
                        
            "CREATE TABLE IF NOT EXISTS settings (
                setting_key VARCHAR(50) PRIMARY KEY,
                setting_value TEXT
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;",
            
                   "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('force_phone_share', 'off');",

            "CREATE TABLE IF NOT EXISTS admins (
                id INT AUTO_INCREMENT PRIMARY KEY,
                user_id BIGINT UNIQUE NOT NULL,
                name VARCHAR(255) NOT NULL,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;",

            "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('admin_notification_mode', 'all');"

        ];


           foreach ($queries as $query) {
            $this->pdo->exec($query);
        }

       
       
        $updates = [
            "ALTER TABLE users ADD COLUMN username VARCHAR(255) DEFAULT NULL",
            "ALTER TABLE users MODIFY temp_data LONGTEXT",
            "ALTER TABLE product_files ADD COLUMN caption TEXT DEFAULT NULL",
            "ALTER TABLE products ADD COLUMN more_description LONGTEXT DEFAULT NULL",
            "ALTER TABLE orders ADD COLUMN coupon_id INT DEFAULT NULL",
            "ALTER TABLE products ADD COLUMN price_stars DECIMAL(15,0) DEFAULT 0",
            "ALTER TABLE products ADD COLUMN discount_price_stars DECIMAL(15,0) DEFAULT 0",
            "ALTER TABLE products ADD COLUMN discount_expiry_stars DATE DEFAULT NULL",
            "ALTER TABLE orders ADD COLUMN payment_method VARCHAR(50) DEFAULT 'zarinpal'",
            "ALTER TABLE orders ADD COLUMN receipt_image VARCHAR(255) DEFAULT NULL",
            "ALTER TABLE products ADD COLUMN support_days INT DEFAULT 0",
            "ALTER TABLE orders ADD COLUMN support_expiry DATE DEFAULT NULL",
             "ALTER TABLE orders ADD COLUMN processed_by BIGINT DEFAULT NULL",
            "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('stars_payment_active', 'off')",
            "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('global_discount_active', 'off')",
            "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('global_discount_type', 'fixed')",
            "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('global_discount_value', '0')",
            "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('global_discount_expiry', '2030-01-01')",
            "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('ticket_submission_active', 'on')",
            "ALTER TABLE users ADD COLUMN last_activity DATETIME DEFAULT CURRENT_TIMESTAMP",
             "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('phone_restriction_mode', 'all')",
              
            "CREATE TABLE IF NOT EXISTS coupon_usage (
                id INT AUTO_INCREMENT PRIMARY KEY,
                user_id BIGINT NOT NULL,
                coupon_id INT NOT NULL,
                used_at DATETIME DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;"

           
        ];


        foreach ($updates as $up) {
            try {
                $this->pdo->exec($up);
            } catch (Exception $e) {
               
                continue;
            }
        }
        
       
      
        $this->pdo->exec("CREATE TABLE IF NOT EXISTS product_categories (
            id INT AUTO_INCREMENT PRIMARY KEY,
            product_id INT NOT NULL,
            category_id INT NOT NULL,
            UNIQUE KEY unique_product_cat (product_id, category_id),
            FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE,
            FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");


       
       
        try {
            $this->pdo->exec("INSERT IGNORE INTO product_categories (product_id, category_id)
            SELECT id, category_id FROM products WHERE category_id IS NOT NULL AND category_id > 0;");
        } catch (Exception $e) {
           
        }

        

        $this->pdo->exec("CREATE TABLE IF NOT EXISTS support_messages (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id BIGINT NOT NULL,
            admin_msg_id BIGINT NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");
        
             
        $this->pdo->exec("CREATE TABLE IF NOT EXISTS broadcast_history (
            id INT AUTO_INCREMENT PRIMARY KEY,
            admin_id BIGINT NOT NULL,
            message_type VARCHAR(50) NOT NULL COMMENT 'نوع پیام: text, photo, forward, etc',
            total_receivers INT DEFAULT 0 COMMENT 'تعداد کل گیرندگان',
            success_count INT DEFAULT 0 COMMENT 'تعداد ارسال موفق',
            failed_count INT DEFAULT 0 COMMENT 'تعداد ارسال ناموفق',
            start_time DATETIME DEFAULT CURRENT_TIMESTAMP,
            end_time DATETIME NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");


       
        $this->pdo->exec("CREATE TABLE IF NOT EXISTS force_join_channels (
            id INT AUTO_INCREMENT PRIMARY KEY,
            chat_id VARCHAR(50) NOT NULL,
            name VARCHAR(255) NOT NULL,
            invite_link VARCHAR(255) NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");

       
        $this->pdo->exec("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('force_join_active', 'off');");

       
      
                $this->pdo->exec("CREATE TABLE IF NOT EXISTS product_ticket_messages (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id BIGINT NOT NULL,
            admin_msg_id BIGINT NOT NULL,
            user_msg_id BIGINT DEFAULT NULL, 
            product_id INT NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");

       
        $this->pdo->exec("CREATE TABLE IF NOT EXISTS admins (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id BIGINT NOT NULL UNIQUE,
            name VARCHAR(255) DEFAULT 'Admin',
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");

       
        try {
            $this->pdo->exec("ALTER TABLE admins ADD COLUMN name VARCHAR(255) DEFAULT 'Admin';");
        } catch (Exception $e) {
           
        }

       
       
        $this->pdo->exec("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('admin_notification_mode', 'all');");


        try {
            $this->pdo->exec("DELETE FROM product_categories WHERE product_id NOT IN (SELECT id FROM products)");
            $this->pdo->exec("DELETE FROM product_files WHERE product_id NOT IN (SELECT id FROM products)");
            $this->pdo->exec("DELETE FROM product_gallery WHERE product_id NOT IN (SELECT id FROM products)");
        } catch (Exception $e) {
           
        }

       
        try {
           
            $this->pdo->exec("ALTER TABLE product_categories
                ADD CONSTRAINT fk_pro_cat_product
                FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE");
        } catch (Exception $e) {
           
        }
        
        try {
            $this->pdo->exec("ALTER TABLE product_categories
                ADD CONSTRAINT fk_pro_cat_category
                FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE CASCADE");
        } catch (Exception $e) {}


        try {
            $this->pdo->exec("ALTER TABLE product_files
                ADD CONSTRAINT fk_pro_file_product
                FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE");
        } catch (Exception $e) {}

        try {
            $this->pdo->exec("ALTER TABLE product_gallery
                ADD CONSTRAINT fk_pro_gallery_product
                FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE");
        } catch (Exception $e) {}


    }
}


// نصب خودکار در اولین اجرا
$db = new Database();
$db->install();
?>
