<?php
// index.php

// 1. دریافت ورودی خام تلگرام
$content = file_get_contents("php://input");
$update = json_decode($content);

// 2. لود کردن تنظیمات برای دسترسی به API_KEY
// (فرض بر این است که config.php در همین پوشه است)
if (file_exists('config.php')) {
    require_once 'config.php';
} else {
    // اگر فایل کانفیگ پیدا نشد، لاگ بگیر و متوقف شو
    file_put_contents('error_log.txt', "Config file missing!\n", FILE_APPEND);
    die();
}

// -----------------------------------------------------------
// ⚡️ اولویت اول: پاسخ سریع به درخواست پرداخت (بدون درگیری با دیتابیس)
// -----------------------------------------------------------
if (isset($update->pre_checkout_query)) {
    $url = "https://api.telegram.org/bot" . API_KEY . "/answerPreCheckoutQuery";
    $params = [
        'pre_checkout_query_id' => $update->pre_checkout_query->id,
        'ok' => true
    ];
    
    // ارسال درخواست با cURL با سرعت بالا
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5); // تایم‌اوت کوتاه برای سرعت
    $res = curl_exec($ch);
    curl_close($ch);
    
    // توقف کامل اسکریپت تا کدهای سنگین دیتابیس اجرا نشوند
    exit;
}
// -----------------------------------------------------------

// 3. حالا فایل‌های سنگین را لود می‌کنیم (برای پیام‌های عادی)
require_once 'database.php';
require_once 'functions.php';

$chat_id = null;
$text = null;
$data = '';
$step = 'none';

// 4. تشخیص نوع ورودی
if (isset($update->message)) {
    $message = $update->message;
    $chat_id = $message->chat->id;
    $text = isset($message->text) ? $message->text : '';
    $from_id = $message->from->id;
    $first_name = $message->from->first_name;
} elseif (isset($update->callback_query)) {
    $chat_id = $update->callback_query->message->chat->id;
    $data = $update->callback_query->data;
    $from_id = $update->callback_query->from->id;
    $first_name = '';
}

// اگر آپدیت پردازش نشده بود (مثلا آپدیت‌های سیستمی دیگر)، خارج شو
if (!$chat_id) {
    die();
}

// 5. ثبت نام یا دریافت وضعیت کاربر
try {
    $stmt = $db->pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$chat_id]);
    $user = $stmt->fetch();

    if (!$user) {
        if (isset($update->message)) {
            $db->pdo->prepare("INSERT INTO users (id, name) VALUES (?, ?)")->execute([$chat_id, $first_name]);
        } else {
            $db->pdo->prepare("INSERT INTO users (id, name) VALUES (?, ?)")->execute([$chat_id, 'User']);
        }
        $step = 'none';
    } else {
        $step = $user['step'];
    }
} catch (Exception $e) {
    // اگر دیتابیس خطا داد، لاگ بگیر ولی نگذار ربات کرش کند
    file_put_contents('db_error.log', $e->getMessage(), FILE_APPEND);
}

// --- دریافت و ذخیره یوزرنیم (اضافه شده برای رفع مشکل جستجو) ---
$username = '';
if (isset($update->message->from->username)) {
    $username = $update->message->from->username;
} elseif (isset($update->callback_query->from->username)) {
    $username = $update->callback_query->from->username;
}

// آپدیت یوزرنیم در دیتابیس (فقط اگر یوزرنیم وجود داشت)
if ($chat_id && !empty($username)) {
    // چون در کدهای بالا (مرحله 5) از وجود کاربر مطمئن شدیم، اینجا فقط آپدیت می‌کنیم
    $db->pdo->prepare("UPDATE users SET username = ? WHERE id = ?")->execute([$username, $chat_id]);
}

// --- آپدیت زمان آخرین فعالیت (اضافه شده برای محاسبه آمار آنلاین) ---
if ($chat_id) {
    // این دستور هر بار که کاربر تعاملی داشته باشد، زمان را به روز می‌کند
    $db->pdo->prepare("UPDATE users SET last_activity = CURRENT_TIMESTAMP WHERE id = ?")->execute([$chat_id]);
}



// 6. هندل کردن دستورات متنی
if (isset($update->message)) {
    if ($text == '/start') {
         // دریافت اطلاعات ربات برای استخراج نام آن
    $getMe = bot('getMe');
    // اگر نام دریافت شد آن را بگذار، در غیر این صورت پیش‌فرض "فروشگاه" باشد
    $bot_name = isset($getMe->result->first_name) ? $getMe->result->first_name : 'فروشگاه';

    $db->pdo->prepare("UPDATE users SET step = 'none' WHERE id = ?")->execute([$chat_id]);
    
    // ارسال پیام با فرمت درخواست شده: نام کاربر و نام ربات
    bot('sendMessage', [
        'chat_id' => $chat_id, 
        'text' => "سلام $first_name عزیز  به فروشگاه $bot_name خوش آمدید 🤗", 
        'reply_markup' => mainMenu($chat_id)
    ]);
    exit;

    }
    elseif (strpos($text, '/start support_') === 0) {
        $pid = str_replace('/start support_', '', $text);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "پیام خود را برای پشتیبانی محصول $pid بنویسید.", 'reply_markup' => json_encode(['keyboard' => [[['text' => '🔙 بازگشت به منوی اصلی']]], 'resize_keyboard' => true])]);
        $db->pdo->prepare("UPDATE users SET step = 'support_chat' WHERE id = ?")->execute([$chat_id]);
        exit;
    }
       elseif ($step == 'support_chat' && $text != '🔙 بازگشت به منوی اصلی') {
        // دریافت لیست ادمین‌های بخش پشتیبانی
        $admins = getAdminsForNotification('support');
        if (empty($admins)) $admins = [ADMIN_ID];

        // ارسال پیام برای همه ادمین‌ها
        foreach ($admins as $adm_id) {
            $fwd = bot('forwardMessage', [
                'chat_id' => $adm_id, 
                'from_chat_id' => $chat_id, 
                'message_id' => $message->message_id
            ]);

            // ثبت در دیتابیس برای قابلیت ریپلای
            if (isset($fwd->result->message_id)) {
                $admin_msg_id = $fwd->result->message_id;
                $db->pdo->prepare("INSERT INTO support_messages (user_id, admin_msg_id) VALUES (?, ?)")
                       ->execute([$chat_id, $admin_msg_id]);
            }
        }

        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "پیام شما به تیم پشتیبانی ارسال شد."]);
        exit;
    }

    elseif ($text == '🔙 بازگشت به منوی اصلی') {
        $db->pdo->prepare("UPDATE users SET step = 'none' WHERE id = ?")->execute([$chat_id]);
        bot('sendMessage', ['chat_id' => $chat_id, 'text' => "منوی اصلی:", 'reply_markup' => mainMenu($chat_id)]);
        exit;
    }
}

// 7. لود کردن پنل‌ها
include 'user_panel.php';

// اگر کاربر ادمین اصلی است یا در لیست ادمین‌های فرعی وجود دارد
if (isAdmin($chat_id)) {
    include 'admin_panel.php';
}

?>
